import { gql } from "apollo-server-express";

const assetTypeDefs = gql`
  type Product {
    id: ID!
    productName: String!
    productImage: String
    description: String
    assetClass: String
    minimumInvestment: Float
    investorType: String
  }

  type Asset {
    id: ID!
    market: String!
    numberOfInvestments: Int!
    benchmark: String
    inceptionDate: String
    products: [Product!]!
  }

  input ProductInput {
    productName: String!
    productImage: String
    description: String
    assetClass: String
    minimumInvestment: Float
    investorType: String
  }

  input AssetInput {
    market: String!
    numberOfInvestments: Int!
    benchmark: String
    inceptionDate: String
    products: [ProductInput!]!
  }

  type PaginatedAssets {
    items: [Asset!]!
    total: Int!
    page: Int!
    perPage: Int!
    totalPages: Int!
  }

  type CreateAssetResponse {
  success: Boolean!
  message: String!
  data: Asset
}

  type Query {
    getAllAssets: [Asset!]!
    getAssetByPage(
      searchQuery: String
      page: Int
      perPage: Int
    ): PaginatedAssets!
    getAssetById(id: ID!): Asset
  }

  type Mutation {
    createAsset(input: AssetInput!): CreateAssetResponse!
  }
`;

export default assetTypeDefs;
