import { gql } from "apollo-server-express";

const copperPositionUserTypeDefs = gql`
  type CopperPositionUser {
    id: ID!
    wallet_address: String!
    first_position_date: String!
    last_position_date: String!
    total_positions_opened: Int!
    is_active: Boolean!
    created_at: String!
    updated_at: String!
  }

  input AddCopperUserInput {
    wallet_address: String!
  }

  type CopperUserResponse {
    success: Boolean!
    message: String
    user: CopperPositionUser
  }

  type Query {
    getAllCopperUsers: [CopperPositionUser!]!
    getActiveCopperUsers: [CopperPositionUser!]!
    getCopperUserByWallet(wallet_address: String!): CopperPositionUser
    getActiveCopperUserCount: Int!
  }

  type Mutation {
    addCopperUser(input: AddCopperUserInput!): CopperUserResponse!
    deactivateCopperUser(wallet_address: String!): CopperUserResponse!
    deleteCopperUser(wallet_address: String!): CopperUserResponse!
  }
`;

export default copperPositionUserTypeDefs;
