import { gql } from "apollo-server-express";

const goldPositionUserTypeDefs = gql`
  type GoldPositionUser {
    id: ID!
    wallet_address: String!
    first_position_date: String!
    last_position_date: String!
    total_positions_opened: Int!
    is_active: Boolean!
    created_at: String!
    updated_at: String!
  }

  input AddGoldUserInput {
    wallet_address: String!
  }

  type GoldUserResponse {
    success: Boolean!
    message: String
    user: GoldPositionUser
  }

  type Query {
    getAllGoldUsers: [GoldPositionUser!]!
    getActiveGoldUsers: [GoldPositionUser!]!
    getGoldUserByWallet(wallet_address: String!): GoldPositionUser
    getActiveGoldUserCount: Int!
  }

  type Mutation {
    addGoldUser(input: AddGoldUserInput!): GoldUserResponse!
    deactivateGoldUser(wallet_address: String!): GoldUserResponse!
    deleteGoldUser(wallet_address: String!): GoldUserResponse!
  }
`;

export default goldPositionUserTypeDefs;
