import { gql } from "apollo-server-express";

const oilPositionUserTypeDefs = gql`
  type OilPositionUser {
    id: ID!
    wallet_address: String!
    first_position_date: String!
    last_position_date: String!
    total_positions_opened: Int!
    is_active: Boolean!
    created_at: String!
    updated_at: String!
  }

  input AddOilUserInput {
    wallet_address: String!
  }

  type OilUserResponse {
    success: Boolean!
    message: String
    user: OilPositionUser
  }

  type Query {
    getAllOilUsers: [OilPositionUser!]!
    getActiveOilUsers: [OilPositionUser!]!
    getOilUserByWallet(wallet_address: String!): OilPositionUser
    getActiveOilUserCount: Int!
  }

  type Mutation {
    addOilUser(input: AddOilUserInput!): OilUserResponse!
    deactivateOilUser(wallet_address: String!): OilUserResponse!
    deleteOilUser(wallet_address: String!): OilUserResponse!
  }
`;

export default oilPositionUserTypeDefs;
