import { gql } from "apollo-server-express";

const silverPositionUserTypeDefs = gql`
  type SilverPositionUser {
    id: ID!
    wallet_address: String!
    first_position_date: String!
    last_position_date: String!
    total_positions_opened: Int!
    is_active: Boolean!
    created_at: String!
    updated_at: String!
  }

  input AddSilverUserInput {
    wallet_address: String!
  }

  type SilverUserResponse {
    success: Boolean!
    message: String
    user: SilverPositionUser
  }

  type Query {
    getAllSilverUsers: [SilverPositionUser!]!
    getActiveSilverUsers: [SilverPositionUser!]!
    getSilverUserByWallet(wallet_address: String!): SilverPositionUser
    getActiveSilverUserCount: Int!
  }

  type Mutation {
    addSilverUser(input: AddSilverUserInput!): SilverUserResponse!
    deactivateSilverUser(wallet_address: String!): SilverUserResponse!
    deleteSilverUser(wallet_address: String!): SilverUserResponse!
  }
`;

export default silverPositionUserTypeDefs;
