import { gql } from "apollo-server-express";

const userTypeDefs = gql`
  enum UserType {
    SUPERADMIN
    ADMIN
    CUSTOMER
  }

  type User {
    id: ID!
    username: String!
    email: String!
    firstName: String!
    lastName: String!
    country: String
    pincode: String
    companyName: String
    phoneNumber: String
    userType: UserType!
    createdAt: String!
    address: String
    approval: Boolean
  }

  type UsersResult {
    items: [User!]!
    totalCount: Int!
    totalPages: Int!
    page: Int!
    perPage: Int!
  }

  input CreateCustomerInput {
    email: String!
    username: String!
    password: String!
    userType: UserType
  }

  input UpdateCustomerInput {
    id: ID!
    username: String
    password: String
    userType: UserType
  }
  input UpdateProfileInput {
  id: ID!
  firstName: String
  lastName: String
  email: String
  country: String
  pincode: String
  companyName: String
  phoneNumber: String
  address: String
  userType:  String
  }

  input RegisterUserInput {
    email: String!
    password: String!
  }

  type AuthPayload {
    token: String!
    user: User!
  }

  type passwordResponse {
    success: Boolean
    message: String
  }

  type Query {
    me: User
    users: [User!]!
    getCustomer(id: ID!): User
    getUserByToken(token: String!): User
    getAllUserDetails(page: Int, perPage: Int, searchQuery: String): UsersResult!
  }

  type Mutation {
    registerUser(input: RegisterUserInput!): AuthPayload!
    loginUser(email: String!, password: String!): AuthPayload!
    updateProfile(input: UpdateProfileInput!): User!
    forgotPassword(email: String!): passwordResponse!
    changePassword(token: String!, newPassword: String!): passwordResponse!
    changePasswordOnProfile(email: String!, newPassword: String!): passwordResponse!
    emailVerification(email: String!): passwordResponse!
    emailApproval(token: String!): passwordResponse!
    customerVerification(email: String!): passwordResponse!
    createCustomer(input: CreateCustomerInput!): User!
    updateCustomer(input: UpdateCustomerInput!): User!
    updateCustomerStatus(id: ID!, approval: Boolean!): passwordResponse!
    deleteCustomerById(id: ID!): passwordResponse!
  }
`;

export default userTypeDefs;
