const fs = require('fs');
const path = require('path');
const dotenv = require('dotenv');

dotenv.config({ path: path.resolve(__dirname, '../.env') });

const sourceEnvPath = path.resolve(__dirname, '../.env');
const targetEnvPath = path.join(__dirname, '.env');

try {
    if (!fs.existsSync(sourceEnvPath)) {
        console.error('Source .env file does not exist.');
    } else {
        fs.copyFileSync(sourceEnvPath, targetEnvPath);
        console.info('Environment variables loaded successfully.');
    }
} catch (error) {
    console.error('Error copying .env file:', error);
}
