import React from "react";
import {
  Dialog,
  DialogTitle,
  DialogContent,
  DialogContentText,
  DialogActions,
  Button,
  IconButton,
} from "@mui/material";
import CloseIcon from "@mui/icons-material/Close";
import themestyle from "../theme";

interface ConfirmDialogProps {
  open: boolean;
  title: string;
  message: string;
  onConfirm: () => void;
  onClose: () => void;
  confirmText?: string;
  cancelText?: string;
}

const ConfirmDialog: React.FC<ConfirmDialogProps> = ({
  open,
  title,
  message,
  onConfirm,
  onClose,
  confirmText,
  cancelText = "Cancel",
}) => {
  return (
    <Dialog
      open={open}
      onClose={onClose}
     
      fullWidth
      PaperProps={{
        sx: {
          borderRadius: 3,
          textAlign: "center",
          padding: 1,
           maxWidth:"340px"
        },
      }}
    >
      <IconButton
        onClick={onClose}
        sx={{ position: "absolute", right: 8, top: 8 }}
      >
        <CloseIcon />
      </IconButton>

      <DialogTitle
        sx={{
          fontWeight: "bold",
          fontSize: "1rem",
          marginTop: 1,
          color: themestyle.colors.primary,
        }}
      >
        {title}
      </DialogTitle>

      <DialogContent>
        <DialogContentText
          sx={{
            fontSize: "0.95rem",
            color: "text.secondary",
            paddingX: 3,
            marginBottom: 1,
          }}
        >
          {message}
        </DialogContentText>
      </DialogContent>

      <DialogActions
        sx={{
          flexDirection: "column",
          gap: 2,
          paddingBottom: 2,
        }}
      >
        <Button
          variant="contained"
          onClick={onConfirm}
          fullWidth
          sx={{
            textTransform: "none",
            fontSize: "0.85rem",
            bgcolor: themestyle.colors.primary,
            color: "#FFFFFF",
            borderRadius: "20px",
            width: "120px",
            height: "35px",
            "&:hover": {
              backgroundColor: themestyle.colors.primary,
            },
          }}
        >
          {confirmText}
        </Button>
        <Button
          onClick={onClose}
          variant="outlined"
          sx={{
            textTransform: "none",
            fontSize: "0.85rem",
            color: themestyle.colors.primary,
            backgroundColor: "#FFFFFF",
            borderRadius: "20px",
            borderColor: themestyle.colors.primary,
            width: "120px",
            height: "35px",
            "&:hover": {
              borderColor: themestyle.colors.primary,
              color: themestyle.colors.primary,
            },
          }}
        >
          {cancelText}
        </Button>
      </DialogActions>
    </Dialog>
  );
};

export default ConfirmDialog;
