import React from 'react';
import { makeStyles } from '@mui/styles';
import PheonixSearch from './Search';
import { SxProps, Theme, Box } from '@mui/material'; 

const useStyles = makeStyles({
  toolbarContainer: {
    padding: '10px',
    borderRadius: '4px',
    marginTop: '10px',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
});

interface CustomToolbarProps {
  onSearchQueryChange?: (query: string) => void;
  searchQuery: string;
  sx?: SxProps<Theme>;
}

const CustomToolbar: React.FC<CustomToolbarProps> = ({
  onSearchQueryChange,
  searchQuery,
  sx,
}) => {
  const classes = useStyles();

  return (
    <Box
      className={classes.toolbarContainer}
      sx={{
        display: 'flex',
        justifyContent: 'space-between',
        padding: '10px',
        ...sx, 
      }}
    >
      <Box >
        {onSearchQueryChange && (
          <PheonixSearch value={searchQuery} onChange={onSearchQueryChange} />
        )}
      </Box>
    </Box>
  );
};

export default CustomToolbar;