import React, { useState, ChangeEvent, KeyboardEvent } from "react";
import SearchProps from "../interfaces/SerarchProps";
import { TextField, InputAdornment, IconButton } from "@mui/material";
import SearchIcon from "@mui/icons-material/Search";
import CloseIcon from "@mui/icons-material/Close";

const Search: React.FC<SearchProps> = ({ value, onChange }) => {
  const [query, setQuery] = useState(value);
  const [isFocused, setIsFocused] = useState(false);

  const handleChange = (event: ChangeEvent<HTMLInputElement>) => {
    setQuery(event.target.value);
  };

  const handleSearchClick = () => {
    onChange(query);
  };

  const handleKeyDown = (event: KeyboardEvent<HTMLDivElement>) => {
    if (event.key === "Enter") {
      event.preventDefault();
      onChange(query);
    }
  };

  const handleClear = () => {
    setQuery("");
    onChange("");
  };

  return (
    <div style={{ display: "flex", alignItems: "center", marginRight: "10px" }}>
      <TextField
        variant="outlined"
        size="small"
        value={query}
        onChange={handleChange}
        onKeyDown={handleKeyDown}
        placeholder="Search..."
        onFocus={() => setIsFocused(true)}
        onBlur={() => setIsFocused(false)}
        InputProps={{
          startAdornment: (
            <InputAdornment position="start">
              <IconButton onClick={handleSearchClick}>
                <SearchIcon sx={{ color: "#666666", fontSize: "20px" }} />
              </IconButton>
            </InputAdornment>
          ),
          endAdornment: (
            <InputAdornment position="end">
              {query && (
                <IconButton onClick={handleClear}>
                  <CloseIcon sx={{ color: "#666666", fontSize: "20px" }} />
                </IconButton>
              )}
            </InputAdornment>
          ),
          sx: {
            "& .MuiOutlinedInput-notchedOutline": {
              borderRadius: "50px",
            },
            "& .MuiInputBase-root": {
              backgroundColor: "#FFFFFF",
              border: "1px solid #E0E0E0",
              borderRadius: "50px",
              padding: "4px 12px",
              width: "250px",
              height: "36px",
            },
            "& .MuiInputBase-input": {
              padding: "6px 0",
              fontSize: "14px",
              color: "#666666",
              fontFamily: "Roboto, sans-serif",
              fontWeight: 400,
            },
            "& .MuiInputBase-input::placeholder": {
              color: "#666666",
              fontFamily: "Roboto, sans-serif",
              fontWeight: 400,
              opacity: 1,
            },
          },
        }}
        sx={{
          width: "100%",
          "& .MuiOutlinedInput-root": {
            "&:hover fieldset": {
              borderRadius: "50px",
            },
            "&.Mui-focused fieldset": {
              borderRadius: "50px",
            },
          },
        }}
      />
    </div>
  );
};

export default Search;
