import React, { useState, useEffect } from "react";
import themestyle from "../theme";
import { TEXT } from "../const";

const Footer: React.FC<{ style?: React.CSSProperties }> = ({ style }) => {
  const [currentYear] = useState(new Date().getFullYear());

  return (
    <div
      style={{
        textAlign: "center",
        color: themestyle.colors.secondary,
        backgroundColor:   "white",
        fontSize: "14px",
        fontWeight: 500,
        padding: "5px 0",
        position: "fixed",
        bottom: 0,
        width: "100%",
        fontFamily: themestyle.fontFamily.lato,
        ...style,
      }}
    >
     {TEXT.FOOTER_COPYRIGHTS}{" "}{currentYear}.
    </div>
  );
};

export default Footer;