import React from "react";
import Header from "./header";
import Footer from "./footer";
import { Box } from "@mui/material";
import themestyle from "../theme";
import Sidebar from "../pages/Shared/Sidebar";
import { useLocation } from "react-router-dom";
import { useSidebar } from "../components/sidebarContext";
import logo from "../assets/logo-bg.png";

interface LayoutProps {
  title: string;
  children: React.ReactNode;
}

const hideMenuRoutes = [
  "/reset-password",
  "/signup",
  "/clientonboard",
  "/",
  "/change-password",
  "/admin/signup",
  "/admin/changepassword",
  "/admin/profile",
  "/admin/login",
  "/admin/resetpassword",
  "/admin/emailverification",
  "/emailverification",
  "/KYC",
  "/kyc",
  "/didit-verification",
  "/verification-callback",
  "/auth-callback",
];

const Layout: React.FC<LayoutProps> = ({ title, children }) => {
  const location = useLocation();
  const { isOpen } = useSidebar();
  const shouldHideSidebar = hideMenuRoutes.includes(location.pathname);

  return (
    <Box
      sx={{
        display: "flex",
        flexDirection: "column",
        minHeight: "100vh",
        backgroundColor: "#F9FAFC",
      }}
    >
      {!shouldHideSidebar && (
        <Box sx={{ paddingTop: "64px" }}>
          {!shouldHideSidebar && (
            <Header shouldHideSidebar={shouldHideSidebar} />
          )}
        </Box>
      )}

      {shouldHideSidebar && (
        <Box
          sx={{
            display: "flex",
            alignItems: "center",
            padding: "10px 20px",
            backgroundColor: "#FFFFFF",
          }}
        >
          <img
            src={logo}
            alt="Intelliwealth Logo"
            style={{ height: "40px", marginRight: "20px" }}
          />
        </Box>
      )}
      {!shouldHideSidebar && <Sidebar />}
      <Box
        sx={{
          flexGrow: 1,
          overflowY: "auto",
          paddingBottom: "50px",
          marginLeft: !shouldHideSidebar
            ? {
                xs: 0,
                sm: isOpen ? "230px" : "90px",
              }
            : 0,
          transition: "margin-left 0.3s ease-in-out",
        }}
      >
        {children}
      </Box>
      <Box
        sx={{
          marginLeft: !shouldHideSidebar
            ? {
                xs: 0,
                sm: isOpen ? "100px" : "90px",
              }
            : 0,
          transition: "margin-left 0.3s ease-in-out",
        }}
      >
        <Footer />
      </Box>
    </Box>
  );
};

export default Layout;
