import { gql } from "@apollo/client";

export const LOGIN_USER = gql`
  mutation LoginUser($email: String!, $password: String!) {
    loginUser(email: $email, password: $password) {
      token
      user {
        id
        username
        email
        firstName
        lastName
        country
        address
        pincode
        companyName
        userType
        createdAt
      }
    }
  }
`;
export const REGISTER_USER = gql`
  mutation RegisterUser($input: RegisterUserInput!) {
    registerUser(input: $input) {
      token
      user {
        id
        username
        email
        firstName
        lastName
        country
        pincode
        companyName
        phoneNumber
        address
        userType
        createdAt
      }
    }
  }
`;

export const UPDATE_PROFILE_USER = gql`
  mutation UpdateProfile($input: UpdateProfileInput!) {
    updateProfile(input: $input) {
      id
      username
      email
      firstName
      lastName
      country
      address
      pincode
      phoneNumber
      companyName
      userType
      createdAt
    }
  }
`;

export const FORGOT_PASSWORD = gql`
  mutation ForgotPassword($email: String!) {
    forgotPassword(email: $email) {
      success
      message
    }
  }
`;

export const CHANGE_PASSWORD = gql`
  mutation ChangePassword($token: String!, $newPassword: String!) {
    changePassword(token: $token, newPassword: $newPassword) {
      success
      message
    }
  }
`;

export const CHANGE_PASSWORD_ON_PROFILE = gql`
  mutation ChangePasswordOnProfile($email: String!, $newPassword: String!) {
    changePasswordOnProfile(email: $email, newPassword: $newPassword) {
      success
      message
    }
  }
`;

export const CREATE_ASSET = gql`
  mutation CreateAsset($input: AssetInput!) {
    createAsset(input: $input) {
      success
      message
      data {
        id
        market
        numberOfInvestments
        benchmark
        inceptionDate
        products {
          id
          productName
          productImage
          description
          assetClass
          minimumInvestment
          investorType
        }
      }
    }
  }
`;

export const EMAIL_VERIFICATION = gql`
  mutation EmailVerification($email: String!) {
    emailVerification(email: $email) {
      success
      message
    }
  }
`;

export const CUSTOMER_EMAIL_VERIFICATION = gql`
  mutation CustomerVerification($email: String!) {
    customerVerification(email: $email) {
      success
      message
    }
  }
`;

export const EMAIL_APPROVAL = gql`
  mutation EmailApproval($token: String!) {
    emailApproval(token: $token) {
      success
      message
    }
  }
`;

// Admin mutations for user management
export const CREATE_CUSTOMER = gql`
  mutation CreateCustomer($input: CreateCustomerInput!) {
    createCustomer(input: $input) {
      id
      username
      email
      userType
      approval
      createdAt
    }
  }
`;

export const UPDATE_CUSTOMER = gql`
  mutation UpdateCustomer($input: UpdateCustomerInput!) {
    updateCustomer(input: $input) {
      id
      username
      email
      userType
      approval
      createdAt
    }
  }
`;

export const UPDATE_CUSTOMER_STATUS = gql`
  mutation UpdateCustomerStatus($id: ID!, $approval: Boolean!) {
    updateCustomerStatus(id: $id, approval: $approval) {
      success
      message
    }
  }
`;

export const DELETE_CUSTOMER_BY_ID = gql`
  mutation DeleteCustomerById($id: ID!) {
    deleteCustomerById(id: $id) {
      success
      message
    }
  }
`;

export const ADD_OIL_USER = gql`
  mutation AddOilUser($wallet_address: String!) {
    addOilUser(input: { wallet_address: $wallet_address }) {
      success
      message
      user {
        wallet_address
        total_positions_opened
      }
    }
  }
`;

export const ADD_GOLD_USER = gql`
  mutation AddGoldUser($wallet_address: String!) {
    addGoldUser(input: { wallet_address: $wallet_address }) {
      success
      message
      user {
        wallet_address
        total_positions_opened
      }
    }
  }
`;

export const ADD_SILVER_USER = gql`
  mutation AddSilverUser($wallet_address: String!) {
    addSilverUser(input: { wallet_address: $wallet_address }) {
      success
      message
      user {
        wallet_address
        total_positions_opened
      }
    }
  }
`;

export const ADD_COPPER_USER = gql`
  mutation AddCopperUser($wallet_address: String!) {
    addCopperUser(input: { wallet_address: $wallet_address }) {
      success
      message
      user {
        wallet_address
        total_positions_opened
      }
    }
  }
`;
