import { gql } from "@apollo/client";

export const GET_CUSTOMER_ID = gql`
  query GetCustomer($id: ID!) {
    getCustomer(id: $id) {
      id
      username
      email
      firstName
      lastName
      country
      pincode
      companyName
      phoneNumber
      userType
      createdAt
      address
    }
  }
`;

export const GET_ALL_ASSETS = gql`
  query GetAssetByPage($searchQuery: String, $page: Int!, $perPage: Int!) {
    getAssetByPage(searchQuery: $searchQuery, page: $page, perPage: $perPage) {
      total
      page
      perPage
      totalPages
      items {
        id
        market
        numberOfInvestments
        benchmark
        inceptionDate
        products {
          id
          productName
          productImage
          description
          assetClass
          minimumInvestment
          investorType
        }
      }
    }
  }
`;

export const GET_ASSET_BY_ID = gql`
  query GetAssetById($id: ID!) {
    getAssetById(id: $id) {
      id
      market
      numberOfInvestments
      benchmark
      inceptionDate
      products {
        id
        productName
        productImage
        description
        assetClass
        minimumInvestment
        investorType
        __typename
      }
      __typename
    }
  }
`;

export const GET_USER_BY_TOKEN = gql`
  query GetUserByToken($token: String!) {
    getUserByToken(token: $token) {
      id
      email
      createdAt
    }
  }
`;
export const GET_ALL_USERSDETAILS = gql`
  query getAllUserDetails($page: Int, $perPage: Int, $searchQuery: String) {
    getAllUserDetails(page: $page, perPage: $perPage, searchQuery: $searchQuery) {
      items {
        id
        username
        email
        firstName
        lastName
        country
        address
        pincode
        companyName
        phoneNumber
        userType
        approval
        createdAt
      }
      totalPages
      totalCount
      page
      perPage
    }
  }
`;
