import React, { CSSProperties } from 'react';
import { GridSlotsComponent } from '@mui/x-data-grid';
import ToolbarProps from './ToolbarProps';

export default interface DataGridProps {
  rows: any[]; 
  columns: any[]; 
  height?: number | string; 
  width?: string | number; 
  components?: Partial<GridSlotsComponent>; 
  customProp?: string;
  style?: CSSProperties;
  paginationModel?: {
    pageSize: number;
    page: number;
  };
  onPaginationModelChange?: (newPaginationModel: { pageSize: number; page: number }) => void;
  pageSizeChange?: (newPageSize: number) => void;
  pageChange?: (newPage: number) => void;
  pageSizeOptions?: number[];
  loader?: React.ReactNode;
  rowCount?: number;
  pageSize?: number;
  currentPage?: number;
  paginationMeta?: any;
  paginationMode?: 'client' | 'server'; 
  toolbar?: boolean;
  onSearchQueryChange?: (newQuery: string) => void;
  searchQuery?: string; 
  loading?: boolean;
  getRowId?: (row: any) => string;
}