import React from "react";
import {
  Box,
  Button,
  Card,
  CardActions,
  CardContent,
  CardMedia,
  Typography,
  useTheme,
  useMediaQuery
} from "@mui/material";
import Grid from "@mui/material/Grid";
import { useNavigate } from "react-router-dom";
import goldImage from "../../assets/Gold.webp";
import silverImage from "../../assets/Silver.jpg";
import oilImage from "../../assets/oil.webp";
import copperImage from "../../assets/Copper.jpeg";
import { TEXT } from "../../const";

const CommoditiesList: React.FC = () => {
  const theme = useTheme();
  const navigate = useNavigate();

  const isMobile = useMediaQuery(theme.breakpoints.down("sm"));
  const isTablet = useMediaQuery(theme.breakpoints.between("sm", "md"));

  // Reusable paragraph style (matches your previous body2 style)
  const pStyle = { color: "#4B5563" };

  const commodities: Array<{
    title: string;
    image: string;
    description: React.ReactNode;
    path: string;
  }> = [
    {
      title: "Gold",
      image: goldImage,
      description: (
        <>
          <Typography variant="body2" sx={pStyle}>
            You can trade Over-the-Counter (OTC) Request for Quotes (RFQs), invest, order physical assets, and
            trade on our RFQ and secondary marketplace.<br/>
          </Typography>
          <br/>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliGold Futures Order-Book &amp; Marketplace</strong>
            <br/><br/>A decentralised platform providing
            a comprehensive order book and marketplace for creating, subscribing to, and trading tokenised gold
            futures. It allows for physical settlement upon contract maturity.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade Gold Futures</strong> <br/><br/> A professional Request for Quote (RFQ) platform for
            trading tokenized gold futures (IGLD). Open and close positions with specified maturities using dynamic,
            on-chain price calculation.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade Gold Futures OTC RFQ</strong> <br/><br/> An institutional-grade Over-the-Counter (OTC)
            trading interface for Gold Futures. Provides advanced capabilities including calendar spreads,
            stop-loss/take-profit orders, and direct wallet integration for secure, cash-settled transactions.
          </Typography>
        </>
      ),
      path: "/markets/commodities/gold",
    },
    {
      title: "WTI Crude Oil",
      image: oilImage,
      description: (
        <>
          <Typography variant="body2" sx={pStyle}>
            You can trade Over-the-Counter (OTC) Request for Quotes (RFQs), invest, order physical assets, and
            trade on our RFQ and secondary marketplace.<br/>
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliWTI Oil Futures Order-Book &amp; Marketplace</strong><br/><br/> A decentralised platform
            providing a comprehensive order book and marketplace for creating, subscribing to, and trading
            tokenised WTI Oil futures. It allows for physical settlement upon contract maturity.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade WTI Oil Futures</strong> <br/><br/>A professional Request for Quote (RFQ) platform for
            trading tokenized WTI Oil futures (I-OIL). Open and close positions with specified maturities using
            dynamic, on-chain price calculation.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade WTI Oil Futures OTC RFQ</strong> <br/><br/> An institutional-grade Over-the-Counter (OTC)
            trading interface for WTI Oil Futures. Provides advanced capabilities including calendar spreads,
            stop-loss/take-profit orders, and direct wallet integration for secure, cash-settled transactions.
          </Typography>
        </>
      ),
      path: "/markets/commodities/oil",
    },
    {
      title: "Silver",
      image: silverImage,
      description: (
        <>
          <Typography variant="body2" sx={pStyle}>
            You can trade Over-the-Counter (OTC) Request for Quotes (RFQs), invest, order physical assets, and
            trade on our RFQ and secondary marketplace.<br/>
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliSilver Futures Order-Book &amp; Marketplace</strong> <br/><br/>A decentralised platform
            providing a comprehensive order book and marketplace for creating, subscribing to, and trading
            tokenised silver futures. It allows for physical settlement upon contract maturity.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade Silver Futures</strong> <br/><br/> A professional Request for Quote (RFQ) platform for
            trading tokenized silver futures (ISILV). Open and close positions with specified maturities using
            dynamic, on-chain price calculation.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade Silver Futures OTC RFQ</strong> <br/><br/>An institutional-grade Over-the-Counter (OTC)
            trading interface for Silver Futures. Provides advanced capabilities including calendar spreads,
            stop-loss/take-profit orders, and direct wallet integration for secure, cash-settled transactions.
          </Typography>
        </>
      ),
      path: "/markets/commodities/silver",
    },
    {
      title: "Copper",
      image: copperImage,
      description: (
        <>
          <Typography variant="body2" sx={pStyle}>
            You can trade Over-the-Counter (OTC) Request for Quotes (RFQs), invest, order physical assets, and
            trade on our RFQ and secondary marketplace.<br/>
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliCopper Futures Order-Book &amp; Marketplace</strong> <br/><br/>A decentralised platform
            providing a comprehensive order book and marketplace for creating, subscribing to, and trading
            tokenised copper futures. It allows for physical settlement upon contract maturity.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade Copper Futures</strong> <br/><br/>A professional Request for Quote (RFQ) platform for
            trading tokenized copper futures (ICOP). Open and close positions with specified maturities using
            dynamic, on-chain price calculation.
          </Typography>
          <Typography variant="body2" sx={pStyle}>
            <strong>IntelliTrade Copper Futures OTC RFQ</strong><br/><br/>An institutional-grade Over-the-Counter (OTC)
            trading interface for Copper Futures. Provides advanced capabilities including calendar spreads,
            stop-loss/take-profit orders, and direct wallet integration for secure, cash-settled transactions.
          </Typography>
        </>
      ),
      path: "/markets/commodities/copper",
    },
  ];

  return (
    <Box
      sx={{
        bgcolor: "#F9FAFC",
        minHeight: "85vh",
        px: { xs: 2, md: 4 },
        py: { xs: 2, md: 6 },
      }}
    >
      <Box sx={{ textAlign: "center", mb: 2 }}>
        <Typography
          variant="h4"
          sx={{ fontWeight: 700, color: "#1A202C", letterSpacing: "-0.5px" }}
        >
          {TEXT.COMMODITIES}
        </Typography>

        <Typography
          variant="body1"
          sx={{
            color: "#718096",
            mt: 1,
            maxWidth: 700,
            mx: "auto",
            lineHeight: 1.6,
          }}
        >
          {TEXT.COMMODITIES_SUB_TITLE}
        </Typography>
      </Box>

      <Grid
        container
        spacing={{ xs: 2, md: 3 }}
        justifyContent="space-between"
        sx={{ maxWidth: 1600, mx: "auto" }}
      >
        {commodities.map((c) => (
          <Grid key={c.title} size={{ xs: 12, sm: "auto" }}>
            <Card
              elevation={3}
              sx={{
                width: { xs: "100%", sm: 320 }, // unchanged
                height: "100%",
                display: "flex",
                flexDirection: "column",
                borderRadius: 2,
              }}
            >
              <CardMedia
                component="img"
                image={c.image}
                alt={c.title}
                loading="lazy"
                sx={{ height: { xs: 160, md: 200 }, objectFit: "cover" }}
              />

              <CardContent sx={{ flexGrow: 1 }}>
                <Typography variant="h6" sx={{ fontWeight: 700, color: "#0b3d91", mb: 1 }}>
                  {c.title}
                </Typography>

                {/* long description goes here, style preserved */}
                <Box sx={{ display: "grid", gap: 1 }}>
                  {c.description}
                </Box>
              </CardContent>

              <CardActions sx={{ p: 2, pt: 0 }}>
                <Button
                  fullWidth
                  variant="contained"
                  onClick={() => navigate(c.path)}
                  sx={{
                    textTransform: "none",
                    fontWeight: 600,
                    borderRadius: 1.5,
                    bgcolor: "#0b3d91",
                    "&:hover": { bgcolor: "#083475" },
                  }}
                >
                  {TEXT.EXPLORE} {c.title}
                </Button>
              </CardActions>
            </Card>
          </Grid>
        ))}
      </Grid>
    </Box>
  );
};

export default CommoditiesList;
