import React from "react";
import {
  Typography,
  useMediaQuery,
  useTheme,
  Box,
  Button,
  Icon,
} from "@mui/material";
import { motion } from "framer-motion";
import Inventory2OutlinedIcon from "@mui/icons-material/Inventory2Outlined";
import SignalCellularAltRoundedIcon from "@mui/icons-material/SignalCellularAltRounded";
import CurrencyExchangeIcon from '@mui/icons-material/CurrencyExchange';
import cube from "../../assets/cube.svg";
import { useNavigate } from "react-router-dom"; 
import { TEXT } from "../../const";

const MarketsCards: React.FC = () => {
  const theme = useTheme();
  const isSmallScreen = useMediaQuery(theme.breakpoints.down("md"));
  const navigate = useNavigate();

  const itemVariants = {
    hidden: { opacity: 0, y: 20 },
    visible: (custom: number) => ({
      opacity: 1,
      y: 0,
      transition: { delay: custom * 0.2, duration: 0.5 },
    }),
  };

  const cardStyles = {
    backgroundColor: "#fff",
    borderRadius: "12px",
    p: 2.5,
    width: isSmallScreen ? "100%" : "300px",
    textAlign: "center",
    boxShadow: "0 4px 8px rgba(0, 0, 0, 0.1)",
    transition: "all 0.3s ease",
    minHeight: "250px", 
    display: "flex",
    flexDirection: "column",
    justifyContent: "space-between",
    "&:hover": {
      boxShadow: "0 6px 12px rgba(0, 0, 0, 0.15)",
      transform: "translateY(-4px)",
    },
  };

  const iconContainerStyles = {
    width: "50px",
    height: "50px",
    borderRadius: "50%",
    backgroundColor: "#e6f0fa",
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    mx: "auto",
    mb: 2.5,
  };

  const titleStyles = {
    fontWeight: 600,
    fontSize: isSmallScreen ? "20px" : "24px",
    color: "#333",
    mb: 1,
  };

  const descriptionStyles = {
    fontWeight: 400,
    fontSize: isSmallScreen ? "14px" : "16px",
    color: "#666",
    mb: 2.5,
  };

  const buttonStyles = {
    color: "#fff",
    px: 2.5,
    py: 1,
    textTransform: "none",
    fontSize: isSmallScreen ? "14px" : "16px",
    bgcolor: "#2563EB",
  "&:hover": { bgcolor: "#1D4ED8" },
  };

  return (
    <Box
      sx={{
        display: "flex",
        flexDirection: "column",
        alignItems: "flex-start",
        bgcolor: "#F9FAFC",
        minHeight: "85vh",
        p: { xs: 2, md: 3 },
      }}
    >
      <Typography
        variant="h5"
        gutterBottom
        sx={{
          color: "#1A202C",
          fontWeight: 600,
          letterSpacing: "-0.3px",
          mb: 4,
          textAlign: "left",
          pl: 0,
        }}
      >
        {TEXT.MARKETS}
      </Typography>
      <Box
        sx={{
          display: "flex",
          justifyContent: "center",
          alignItems: "center",
          flexWrap: "wrap",
          gap: 8,
          width: "100%",
        }}
      >
        <motion.div
          custom={0}
          variants={itemVariants}
          initial="hidden"
          animate="visible"
          style={{ width: isSmallScreen ? "100%" : "300px" }}
        >
          <Box sx={cardStyles}>
            <Box sx={{ flexGrow: 1 }}>
              <Box sx={iconContainerStyles}>
                <Icon>
                  <Inventory2OutlinedIcon sx={{ color: "#2463EB" }} />
                </Icon>
              </Box>
              <Typography sx={titleStyles}>{TEXT.PRIVATE_EQUITY}</Typography>
              <Typography sx={descriptionStyles}>
                {TEXT.PRIVATE_EQUITY_DES}
              </Typography>
            </Box>
            <Button
              variant="contained"
              sx={buttonStyles}
              aria-label="View private equity investments"
            >
              {TEXT.COMING_SOON}
            </Button>
          </Box>
        </motion.div>

        <motion.div
          custom={1}
          variants={itemVariants}
          initial="hidden"
          animate="visible"
          style={{ width: isSmallScreen ? "100%" : "300px" }}
        >
          <Box sx={cardStyles}>
            <Box sx={{ flexGrow: 1 }}>
              <Box sx={iconContainerStyles}>
                <Icon
                  sx={{
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "center",
                  }}
                >
                  <img
                    src={cube}
                    alt="Commodities icon"
                    style={{ width: "24px", height: "24px" }}
                  />
                </Icon>
              </Box>
              <Typography sx={titleStyles}>{TEXT.COMMODITIES}</Typography>
              <Typography sx={descriptionStyles}>
               {TEXT.COMMODITIES_DES}
              </Typography>
            </Box>
            <Button
              variant="contained"
              sx={buttonStyles}
              aria-label="View commodities investments"
              onClick={() => navigate("/markets/commodities")}
            >
             {TEXT.VIEW_INVESTMENTS}
            </Button>
          </Box>
        </motion.div>

        <motion.div
          custom={2}
          variants={itemVariants}
          initial="hidden"
          animate="visible"
          style={{ width: isSmallScreen ? "100%" : "300px" }}
        >
          <Box sx={cardStyles}>
            <Box sx={{ flexGrow: 1 }}>
              <Box sx={iconContainerStyles}>
                <Icon>
                  <CurrencyExchangeIcon sx={{ color: "#2463EB"}} />
                </Icon>
              </Box>
              <Typography sx={titleStyles}>Intelliwealth Stablecoin</Typography>
              <Typography sx={descriptionStyles}>
                IntelliWealth IUSD is the stablecoin powering all trading and settlement across our Arbitrum markets.
              </Typography>
            </Box>
            <Button
              variant="contained"
              sx={buttonStyles}
              aria-label="View capital markets investments"
              onClick={() => navigate("/markets/iusdstablecoin")}
            >
              {TEXT.VIEW_INVESTMENTS}
            </Button>
          </Box>
        </motion.div>
      </Box>
    </Box>
  );
};

export default MarketsCards;