import React, { useState } from "react";
import {
  Typography,
  useMediaQuery,
  useTheme,
  Box,
  Button,
  TextField,
} from "@mui/material";
import { useNavigate } from "react-router-dom";
import { motion } from "framer-motion";
import silverImage from "../../assets/Silver.jpg";
import { TEXT } from "../../const";

const Silver: React.FC = () => {
  const theme = useTheme();
  const navigate = useNavigate();
  const isSmallScreen = useMediaQuery(theme.breakpoints.down("md"));
  const [selectedNetwork, setSelectedNetwork] = useState("Arbitrum Network");

  const itemVariants = {
    hidden: { opacity: 0, y: 20 },
    visible: {
      opacity: 1,
      y: 0,
      transition: { duration: 0.5 },
    },
  };

  const cardStyles = {
    backgroundColor: "#fff",
    borderRadius: "16px",
    width: isSmallScreen ? "100%" : "400px",
    boxShadow: "0 4px 12px rgba(0, 0, 0, 0.1)",
    transition: "all 0.3s ease",
    minHeight: "650px", 
    display: "flex",
    flexDirection: "column",
    position: "relative",
    overflow: "hidden",
    "&:hover": {
      boxShadow: "0 8px 16px rgba(0, 0, 0, 0.15)",
      transform: "translateY(-6px)",
    },
  };

  const coverImageStyles = {
    width: "100%",
    height: "200px",
    backgroundSize: "cover",
    backgroundPosition: "center",
    borderRadius: "12px 12px 0 0",
    position: "relative",
  };

  const contentStyles = {
    flexGrow: 1,
    display: "flex",
    flexDirection: "column",
    justifyContent: "space-between",
    p: 2,
    pt: 1,
  };

  const titleStyles = {
    fontWeight: 700,
    fontSize: isSmallScreen ? "22px" : "26px",
    color: "#0b3d91",
    mb: 1.5,
  };

  const descriptionStyles = {
    fontWeight: 400,
    fontSize: isSmallScreen ? "14px" : "16px",
    color: "#455a64",
    mb: 2,
    lineHeight: 1.5,
    textAlign: "left",
  };

  const detailLabelStyles = {
    fontWeight: 500,
    fontSize: isSmallScreen ? "14px" : "15px",
    color: "#455a64",
  };

  const detailValueStyles = {
    fontWeight: 700,
    fontSize: isSmallScreen ? "14px" : "15px",
    color: "#455a64",
  };

  const buttonStyles = {
    bgcolor: "#0b3d91",
    '&:hover': { bgcolor: "#083475", },
    color: "#fff",
    px: 3,
    py: 1.5,
    textTransform: "none",
    fontSize: isSmallScreen ? "14px" : "16px",
    borderRadius: "8px",
    width: "100%",
    mt: 2,
  };

  const textFieldStyles = {
    width: "100%",
    "& .MuiInputBase-input": {
      color: "#455a64",
    },
    "& .MuiOutlinedInput-root": {
      "& fieldset": {
        borderColor: "#90a4ae",
      },
      "&:hover fieldset": {
        borderColor: "#1976d2",
      },
      "&.Mui-focused fieldset": {
        borderColor: "#1976d2",
      },
    },
  };

  return (
    <Box
      sx={{
        display: "flex",
        flexDirection: "column",
        alignItems: "flex-start",
        bgcolor: "#F9FAFC",
        minHeight: "85vh",
        p: { xs: 2, md: 4 },
      }}
    >
      <Typography
        variant="h4"
        sx={{
          color: "#1A202C",
          fontWeight: 700,
          letterSpacing: "-0.5px",
          mb: 4,
          textAlign: "left",
        }}
      >
         Commodities Silver
      </Typography>
      <Box
        sx={{
          display: "flex",
          flexDirection: isSmallScreen ? "column" : "row",
          gap: 4,
          width: "100%",
          flexWrap: "wrap",
        }}
      >
        {/* IntelliSilver Futures OTC RFQ Card */}
        <motion.div
          variants={itemVariants}
          initial="hidden"
          animate="visible"
          style={{ width: isSmallScreen ? "100%" : "400px" }}
        >
          <Box sx={cardStyles}>
            <Box sx={{ ...coverImageStyles, backgroundImage: `url(${silverImage})`, backgroundColor: "#1a1a2e" }} />
            <Box sx={contentStyles}>
              <Box>
                <Typography sx={titleStyles}>
                  {TEXT.INTELLISILVER_FUTURES_OTC_RFQ}
                </Typography>
                <Typography sx={descriptionStyles}>
                  {TEXT.INTELLISILVER_FUTURES_OTC_RFQ_DESCRIPTION}
                </Typography>
                <Box
                  sx={{
                    display: "flex",
                    justifyContent: "space-between",
                    mb: 1,
                  }}
                >
                  <Box>
                    <Typography sx={detailLabelStyles}>{TEXT.ASSET_CLASS}</Typography>
                    <Typography sx={detailValueStyles}>
                      {TEXT.OTC_DERIVATIVES}
                    </Typography>
                  </Box>
                  <Box sx={{ textAlign: "right" }}>
                    <Typography sx={detailLabelStyles}>{TEXT.INVESTMENT}</Typography>
                    <Typography sx={detailValueStyles}>$50,000</Typography>
                  </Box>
                </Box>
                <Box
                  sx={{
                    display: "flex",
                    justifyContent: "space-between",
                    mb: 1,
                  }}
                >
                  <Box>
                    <Typography sx={detailLabelStyles}>{TEXT.INVESTOR_TYPE}</Typography>
                    <Typography sx={detailValueStyles}>{TEXT.INSTITUTIONAL}</Typography>
                  </Box>
                  <Box sx={{ textAlign: "right" }}>
                    <Typography sx={detailLabelStyles}>{TEXT.KEY_FEATURES}</Typography>
                    <Typography sx={detailValueStyles}>
                      {TEXT.CALENDAR_SPREADS}, SL/TP
                    </Typography>
                  </Box>
                </Box>
              </Box>
              <Button
                variant="contained"
                sx={buttonStyles}
                aria-label="Launch OTC Desk"
                onClick={() => navigate("/markets/commodities/silver/intellitradesilver")}
              >
                {TEXT.LAUNCH_OTC_DESK}
              </Button>
            </Box>
          </Box>
        </motion.div>
        <motion.div
          variants={itemVariants}
          initial="hidden"
          animate="visible"
          style={{ width: isSmallScreen ? "100%" : "400px" }}
        >
          <Box sx={cardStyles}>
            <Box sx={{ ...coverImageStyles, backgroundImage: `url(${silverImage})`, backgroundColor: "#1a1a2e" }} />
            <Box sx={contentStyles}>
              <Box>
                <Typography sx={titleStyles}>
                  {TEXT.SILVER_INTELLIWEALTH_IUSD}
                </Typography>
                <Typography sx={descriptionStyles}>
                  {TEXT.SILVER_INTELLIWEALTH_IUSD_DES}
                </Typography>
                <Box
                  sx={{
                    display: "flex",
                    justifyContent: "space-between",
                    mb: 1,
                  }}
                >
                  <Box>
                    <Typography sx={detailLabelStyles}>{TEXT.ASSET_CLASS}</Typography>
                    <Typography sx={detailValueStyles}>
                      {TEXT.UTILITY_STABLECOIN}
                    </Typography>
                  </Box>
                  <Box sx={{ textAlign: "right" }}>
                    <Typography sx={detailLabelStyles}>{TEXT.NETWORK}</Typography>
                    <Typography sx={detailValueStyles}>Arbitrum One</Typography>
                  </Box>
                </Box>
                <Box
                  sx={{
                    display: "flex",
                    justifyContent: "space-between",
                    mb: 1,
                  }}
                >
                  <Box>
                    <Typography sx={detailLabelStyles}>{TEXT.CONVERTIBLE_FROM}</Typography>
                    <Typography sx={detailValueStyles}>USDC, USDT, DAI</Typography>
                  </Box>
                  <Box sx={{ textAlign: "right" }}>
                    <Typography sx={detailLabelStyles}>{TEXT.MIN_TRANSACTION}</Typography>
                    <Typography sx={detailValueStyles}>None</Typography>
                  </Box>
                </Box>
              </Box>
              <Button
                variant="contained"
                sx={buttonStyles}
                aria-label="Acquire IUSD"
                onClick={() => navigate("/markets/commodities/silver/iusdacquire")}
              >
                {TEXT.ACQUIRE_IUSD}
              </Button>
            </Box>
          </Box>
        </motion.div>
      </Box>
    </Box>
  );
};

export default Silver;