import React, { useEffect } from "react";
import { useNavigate } from "react-router-dom";
import { useSession } from "../../context/sessioncontext";

const VerificationCallback: React.FC = () => {
  const navigate = useNavigate();
    const { login } = useSession();

  useEffect(() => {
    const params = new URLSearchParams(window.location.search);
    const status =
      params.get("status") ||
      params.get("result") ||
      params.get("verification_status") ||
      "completed";

    try {
      if (window.opener) {
        window.opener.postMessage({ type: "didit:complete", status }, "*");
      }
      if (window.parent && window.parent !== window) {
        window.parent.postMessage({ type: "didit:complete", status }, "*");
      }
    } catch {
      // ignore
    }
          login();
    navigate("/dashboard", { replace: true });

    // Optionally attempt to close if it’s a popup:
    setTimeout(() => {
      try { window.close(); } catch {}
    }, 300);

  }, [navigate]);

  return null;
};

export default VerificationCallback;
